/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.lexer.Compat;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.constraints.MarkdownConstraintsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006R\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ \u0010\n\u001a\b\u0018\u00010\u0006R\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\u0010\u0005\u001a\u00060\u0006R\u00020\u0007J \u0010\u000b\u001a\b\u0018\u00010\u0006R\u00020\u00072\n\u0010\u0005\u001a\u00060\u0006R\u00020\u00072\u0006\u0010\f\u001a\u00020\u0004J\u001a\u0010\r\u001a\u00020\u000e2\n\u0010\u0005\u001a\u00060\u0006R\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lorg/intellij/markdown/parser/markerblocks/MarkdownParserUtil;", "", "()V", "calcNumberOfConsequentEols", "", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "findNonEmptyLineWithSameConstraints", "getFirstNonWhitespaceLinePos", "eolsToSkip", "hasCodeBlockIndent", "", "isEmptyOrSpaces", "s", "", "markdown"})
public final class MarkdownParserUtil {
    @NotNull
    public static final MarkdownParserUtil INSTANCE = new MarkdownParserUtil();

    private MarkdownParserUtil() {
    }

    public final int calcNumberOfConsequentEols(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        LookaheadText.Position position;
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(constraints, "constraints");
        Compat compat = Compat.INSTANCE;
        boolean condition$iv = pos.getOffsetInCurrentLine() == -1;
        boolean $i$f$assert = false;
        if (!condition$iv) {
            String string;
            String string2 = string = "";
            throw new MarkdownParsingException(string2);
        }
        LookaheadText.Position currentPos = pos;
        int result2 = 1;
        Function1 isClearLine2 = new Function1<LookaheadText.Position, Boolean>(constraints){
            final /* synthetic */ MarkdownConstraints $constraints;
            {
                this.$constraints = $constraints;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull LookaheadText.Position pos) {
                LookaheadText.Position position;
                Intrinsics.checkNotNullParameter(pos, "pos");
                MarkdownConstraints currentConstraints = this.$constraints.applyToNextLine(pos);
                int constraintsLength = MarkdownConstraintsKt.getCharsEaten(currentConstraints, pos.getCurrentLine());
                return MarkdownConstraintsKt.upstreamWith(currentConstraints, this.$constraints) && (constraintsLength >= pos.getCurrentLine().length() || ((position = pos.nextPosition(1 + constraintsLength)) == null ? null : position.charsToNonWhitespace()) == null);
            }
        };
        while (((Boolean)isClearLine2.invoke(currentPos)).booleanValue() && (position = currentPos.nextLinePosition()) != null) {
            currentPos = position;
            int n = result2;
            if ((result2 = n + 1) <= 4) continue;
            break;
        }
        return result2;
    }

    @Nullable
    public final LookaheadText.Position getFirstNonWhitespaceLinePos(@NotNull LookaheadText.Position pos, int eolsToSkip) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        LookaheadText.Position currentPos = null;
        currentPos = pos;
        int n = eolsToSkip - 1;
        boolean bl = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            boolean bl2 = false;
            LookaheadText.Position position = pos.nextLinePosition();
            if (position == null) {
                return null;
            }
            currentPos = position;
        }
        while (currentPos.charsToNonWhitespace() == null) {
            LookaheadText.Position position = currentPos.nextLinePosition();
            if (position == null) {
                return null;
            }
            currentPos = position;
        }
        return currentPos;
    }

    public final boolean hasCodeBlockIndent(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(constraints, "constraints");
        int constraintsLength = MarkdownConstraintsKt.getCharsEaten(constraints, pos.getCurrentLine());
        if (pos.getOffsetInCurrentLine() >= constraintsLength + 4) {
            return true;
        }
        int n = constraintsLength;
        int n2 = pos.getOffsetInCurrentLine();
        if (n <= n2) {
            int i;
            do {
                i = n++;
                if (pos.getCurrentLine().charAt(i) != '\t') continue;
                return true;
            } while (i != n2);
        }
        return false;
    }

    public final boolean isEmptyOrSpaces(@NotNull CharSequence s) {
        Intrinsics.checkNotNullParameter(s, "s");
        CharSequence charSequence = s;
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c == ' ' || c == '\t') continue;
            return false;
        }
        return true;
    }

    @Nullable
    public final LookaheadText.Position findNonEmptyLineWithSameConstraints(@NotNull MarkdownConstraints constraints, @NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter(constraints, "constraints");
        Intrinsics.checkNotNullParameter(pos, "pos");
        LookaheadText.Position currentPos = pos;
        MarkdownConstraints nextLineConstraints;
        while (MarkdownConstraintsKt.upstreamWith(nextLineConstraints = MarkdownConstraintsKt.applyToNextLineAndAddModifiers(constraints, currentPos), constraints) && MarkdownConstraintsKt.extendsPrev(nextLineConstraints, constraints)) {
            CharSequence stringAfterConstraints = MarkdownConstraintsKt.eatItselfFromString(nextLineConstraints, currentPos.getCurrentLine());
            if (!INSTANCE.isEmptyOrSpaces(stringAfterConstraints)) {
                return currentPos;
            }
            LookaheadText.Position position = currentPos.nextLinePosition();
            if (position == null) {
                return null;
            }
            currentPos = position;
        }
        return null;
    }
}

