/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.internal.ToolsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u0000 #2\u00020\u0001:\u0001#B\u0011\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0011J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0011J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0006J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0011J\u0018\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0002J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010 \u001a\u00020\u0010H\u0016J\u0006\u0010!\u001a\u00020\u0010J\u0006\u0010\"\u001a\u00020\u0011J\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/luaj/vm2/Buffer;", "", "initialCapacity", "", "(I)V", "value", "Lorg/luaj/vm2/LuaValue;", "(Lorg/luaj/vm2/LuaValue;)V", "bytes", "", "length", "offset", "append", "b", "", "str", "", "Lorg/luaj/vm2/LuaString;", "val", "concatTo", "lhs", "Lorg/luaj/vm2/LuaNumber;", "makeroom", "", "nbefore", "nafter", "prepend", "s", "realloc", "newSize", "newOffset", "setvalue", "toString", "tojstring", "tostring", "Companion", "luak"})
public final class Buffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private byte[] bytes;
    private int length;
    private int offset;
    @Nullable
    private LuaValue value;
    private static final int DEFAULT_CAPACITY = 64;
    @NotNull
    private static final byte[] NOBYTES = new byte[0];

    @JvmOverloads
    public Buffer(int initialCapacity) {
        this.bytes = new byte[initialCapacity];
        this.length = 0;
        this.offset = 0;
        this.value = null;
    }

    public /* synthetic */ Buffer(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = DEFAULT_CAPACITY;
        }
        this(n);
    }

    public Buffer(@NotNull LuaValue value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.bytes = NOBYTES;
        this.length = this.offset = 0;
        this.value = value;
    }

    @NotNull
    public final LuaValue value() {
        LuaValue luaValue;
        if (this.value != null) {
            LuaValue luaValue2 = this.value;
            luaValue = luaValue2;
            Intrinsics.checkNotNull(luaValue2);
        } else {
            luaValue = this.tostring();
        }
        return luaValue;
    }

    @NotNull
    public final Buffer setvalue(@NotNull LuaValue value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.bytes = NOBYTES;
        this.offset = this.length = 0;
        this.value = value;
        return this;
    }

    @NotNull
    public final LuaString tostring() {
        this.realloc(this.length, 0);
        return LuaString.Companion.valueOf2$default(LuaString.Companion, this.bytes, this.offset, this.length, null, 8, null);
    }

    @NotNull
    public final String tojstring() {
        return this.value().tojstring();
    }

    @NotNull
    public String toString() {
        return this.tojstring();
    }

    @NotNull
    public final Buffer append(byte b) {
        this.makeroom(0, 1);
        Intrinsics.checkNotNull(this.bytes);
        int n = this.length;
        this.length = n + 1;
        this.bytes[this.offset + n] = b;
        return this;
    }

    @NotNull
    public final Buffer append(@NotNull LuaValue val) {
        Intrinsics.checkNotNullParameter(val, "val");
        LuaString luaString = val.strvalue();
        Intrinsics.checkNotNull(luaString);
        this.append(luaString);
        return this;
    }

    @NotNull
    public final Buffer append(@NotNull LuaString str) {
        Intrinsics.checkNotNullParameter(str, "str");
        int n = str.m_length;
        this.makeroom(0, n);
        str.copyInto(0, this.bytes, this.offset + this.length, n);
        this.length += n;
        return this;
    }

    @NotNull
    public final Buffer append(@NotNull String str) {
        Intrinsics.checkNotNullParameter(str, "str");
        char[] cArray = str.toCharArray();
        Intrinsics.checkNotNullExpressionValue(cArray, "this as java.lang.String).toCharArray()");
        char[] c = cArray;
        int n = LuaString.Companion.lengthAsUtf8(c);
        this.makeroom(0, n);
        LuaString.Companion.encodeToUtf8(c, c.length, this.bytes, this.offset + this.length);
        this.length += n;
        return this;
    }

    @NotNull
    public final Buffer concatTo(@NotNull LuaValue lhs) {
        Intrinsics.checkNotNullParameter(lhs, "lhs");
        return this.setvalue(lhs.concat(this.value()));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Buffer concatTo(@NotNull LuaString lhs) {
        Buffer buffer;
        Intrinsics.checkNotNullParameter(lhs, "lhs");
        if (this.value != null) {
            LuaValue luaValue = this.value;
            Intrinsics.checkNotNull(luaValue);
            if (!luaValue.isstring()) {
                LuaValue luaValue2 = this.value;
                Intrinsics.checkNotNull(luaValue2);
                buffer = this.setvalue(lhs.concat(luaValue2));
                return buffer;
            }
        }
        buffer = this.prepend(lhs);
        return buffer;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Buffer concatTo(@NotNull LuaNumber lhs) {
        Buffer buffer;
        Intrinsics.checkNotNullParameter(lhs, "lhs");
        if (this.value != null) {
            LuaValue luaValue = this.value;
            Intrinsics.checkNotNull(luaValue);
            if (!luaValue.isstring()) {
                LuaValue luaValue2 = this.value;
                Intrinsics.checkNotNull(luaValue2);
                buffer = this.setvalue(lhs.concat(luaValue2));
                return buffer;
            }
        }
        LuaString luaString = lhs.strvalue();
        Intrinsics.checkNotNull(luaString);
        buffer = this.prepend(luaString);
        return buffer;
    }

    @NotNull
    public final Buffer prepend(@NotNull LuaString s) {
        Intrinsics.checkNotNullParameter(s, "s");
        int n = s.m_length;
        this.makeroom(n, 0);
        byte[] byArray = s.m_bytes;
        int n2 = s.m_offset;
        Intrinsics.checkNotNull(this.bytes);
        ToolsKt.arraycopy(byArray, n2, this.bytes, this.offset - n, n);
        this.offset -= n;
        this.length += n;
        this.value = null;
        return this;
    }

    public final void makeroom(int nbefore, int nafter) {
        if (this.value != null) {
            LuaValue luaValue = this.value;
            Intrinsics.checkNotNull(luaValue);
            LuaString s = luaValue.strvalue();
            this.value = null;
            LuaString luaString = s;
            Intrinsics.checkNotNull(luaString);
            this.length = luaString.m_length;
            this.offset = nbefore;
            this.bytes = new byte[nbefore + this.length + nafter];
            byte[] byArray = s.m_bytes;
            int n = s.m_offset;
            Intrinsics.checkNotNull(this.bytes);
            ToolsKt.arraycopy(byArray, n, this.bytes, this.offset, this.length);
        } else {
            Intrinsics.checkNotNull(this.bytes);
            if (this.offset + this.length + nafter > this.bytes.length || this.offset < nbefore) {
                int n = nbefore + this.length + nafter;
                int m = n < 32 ? 32 : (n < this.length * 2 ? this.length * 2 : n);
                this.realloc(m, nbefore == 0 ? 0 : m - this.length - nafter);
            }
        }
    }

    private final void realloc(int newSize, int newOffset) {
        Intrinsics.checkNotNull(this.bytes);
        if (newSize != this.bytes.length) {
            byte[] newBytes = new byte[newSize];
            Intrinsics.checkNotNull(this.bytes);
            ToolsKt.arraycopy(this.bytes, this.offset, newBytes, newOffset, this.length);
            this.bytes = newBytes;
            this.offset = newOffset;
        }
    }

    @JvmOverloads
    public Buffer() {
        this(0, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/luaj/vm2/Buffer$Companion;", "", "()V", "DEFAULT_CAPACITY", "", "NOBYTES", "", "luak"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

