/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.core.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.islandoftex.arara.api.AraraException;
import org.islandoftex.arara.core.localization.LanguageController;
import org.islandoftex.arara.core.utils.StringExtensionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\b\u00a8\u0006\n"}, d2={"Lorg/islandoftex/arara/core/ui/InputHandling;", "", "()V", "checkBoolean", "", "value", "", "flatten", "", "list", "core"})
public final class InputHandling {
    @NotNull
    public static final InputHandling INSTANCE = new InputHandling();

    private InputHandling() {
    }

    public final boolean checkBoolean(@NotNull String value) throws AraraException {
        Intrinsics.checkNotNullParameter(value, "value");
        String[] stringArray = new String[]{"yes", "true", "1", "on"};
        List<String> yes = CollectionsKt.listOf(stringArray);
        String[] stringArray2 = new String[]{"no", "false", "0", "off"};
        List<String> no = CollectionsKt.listOf(stringArray2);
        Set set = CollectionsKt.union((Iterable)yes, (Iterable)no);
        String string = value.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        if (!set.contains(string)) {
            stringArray2 = new String[]{value};
            throw new AraraException(StringExtensionsKt.formatString(LanguageController.getMessages().getERROR_CHECKBOOLEAN_NOT_VALID_BOOLEAN(), stringArray2));
        }
        String string2 = value.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        return yes.contains(string2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Object> flatten(@NotNull List<?> list) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(list, "list");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            List<Object> list2;
            Object element$iv$iv;
            Object item = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (item instanceof List) {
                list2 = INSTANCE.flatten((List)item);
            } else {
                Object t = item;
                if (t == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Any");
                }
                list2 = CollectionsKt.listOf(t);
            }
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

