/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.Command;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import java.io.IOException;

public class AtNumberOfNumber
extends Command {
    private int number;
    private int total;
    private boolean isRobust = false;

    public AtNumberOfNumber(String string, int n, int n2) {
        this(string, n, n2, false);
    }

    public AtNumberOfNumber(String string, int n, int n2, boolean bl) {
        super(string);
        if (n < 1 || n > n2 || n2 < 1) {
            throw new IllegalArgumentException(String.format("Invalid %d of %d", n, n2));
        }
        this.number = n;
        this.total = n2;
        this.isRobust = bl;
    }

    @Override
    public Object clone() {
        return new AtNumberOfNumber(this.getName(), this.number, this.total, this.isRobust);
    }

    @Override
    public boolean canExpand() {
        return !this.isRobust;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser, teXParser);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (this.isRobust) {
            return null;
        }
        TeXObjectList teXObjectList2 = new TeXObjectList();
        for (int i = 1; i <= this.total; ++i) {
            TeXObject teXObject = this.popArg(teXParser, teXObjectList);
            if (i != this.number) continue;
            teXObjectList2.add(teXObject);
        }
        return teXObjectList2;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        if (this.isRobust) {
            return null;
        }
        return this.expandonce(teXParser).expandfully(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (this.isRobust) {
            return null;
        }
        return this.expandonce(teXParser, teXObjectList).expandfully(teXParser, teXObjectList);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = null;
        for (int i = 1; i <= this.total; ++i) {
            TeXObject teXObject2 = this.popArg(teXParser, teXObjectList);
            if (i != this.number) continue;
            teXObject = teXObject2;
        }
        TeXParserUtils.process(teXObject, teXParser, teXObjectList);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    @Override
    public String toString() {
        return String.format("%s[name=%s,number=%d,total=%d]", this.getClass().getSimpleName(), this.getName(), this.number, this.total);
    }
}

