untrusted comment: verify with openbsd-71-base.pub
RWR2eHwZTOEiTQotJUecJcpAHmoZ12u6bEI4PgT5EvtOXRuCZv4YBUecmBZv6fTM1mb+hg3fwUVzNbgKJmsJasyw2k/kyza5NgI=

OpenBSD 7.1 errata 007, July 24, 2022:

cron(8) aborted due to strange poll timevals.

Apply by doing:
    signify -Vep /etc/signify/openbsd-71-base.pub -x 007_cron.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install cron:
    cd /usr/src/usr.sbin/cron
    make obj
    make
    make install

Index: usr.sbin/cron/cron.c
===================================================================
RCS file: /cvs/src/usr.sbin/cron/cron.c,v
diff -u -p -u -r1.80 cron.c
--- usr.sbin/cron/cron.c	21 Jan 2022 22:53:20 -0000	1.80
+++ usr.sbin/cron/cron.c	19 Jul 2022 04:10:45 -0000
@@ -358,6 +358,8 @@ cron_sleep(time_t target, sigset_t *mask
 	clock_gettime(CLOCK_REALTIME, &t1);
 	t1.tv_sec += GMToff;
 	timeout.tv_sec = (target * SECONDS_PER_MINUTE - t1.tv_sec) + 1;
+	if (timeout.tv_sec < 0)
+		timeout.tv_sec = 0;
 	timeout.tv_nsec = 0;
 
 	pfd[0].fd = cronSock;
@@ -370,8 +372,10 @@ cron_sleep(time_t target, sigset_t *mask
 		nfds = ppoll(pfd, 1, &timeout, mask);
 		switch (nfds) {
 		case -1:
-			if (errno != EINTR && errno != EAGAIN)
-				err(EXIT_FAILURE, "ppoll");
+			if (errno != EINTR && errno != EAGAIN) {
+				syslog(LOG_ERR, "(CRON) DEATH (ppoll failure: %m)");
+				exit(EXIT_FAILURE);
+			}
 			if (errno == EINTR) {
 				if (got_sigchld) {
 					got_sigchld = 0;
@@ -415,9 +419,7 @@ cron_sleep(time_t target, sigset_t *mask
 		timespecsub(&timeout, &t1, &timeout);
 		memcpy(&t1, &t2, sizeof(t1));
 		if (timeout.tv_sec < 0)
-			timeout.tv_sec = 0;
-		if (timeout.tv_nsec < 0)
-			timeout.tv_nsec = 0;
+			timespecclear(&timeout);
 	}
 }
 
