untrusted comment: verify with openbsd-67-base.pub
RWRmkIA877Io3u4xquVACayb1uI1KLL/br6KM8ES3ZXMfWxjyjNOahBqFF5UJYbMZ0zYtOW37QAHXnpZ070YDRkdL69KclNK8g4=

OpenBSD 6.7 errata 015, July 27, 2020:

In rpki-client, incorrect use of EVP_PKEY_cmp allows an authentication bypass.

Apply by doing:
    signify -Vep /etc/signify/openbsd-67-base.pub -x 015_rpki.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install rpki-client:
    cd /usr/src/usr.sbin/rpki-client
    make obj
    make
    make install

Index: usr.sbin/rpki-client/cert.c
===================================================================
RCS file: /cvs/src/usr.sbin/rpki-client/cert.c,v
diff -u -p -u -r1.15 cert.c
--- usr.sbin/rpki-client/cert.c	2 Apr 2020 09:16:43 -0000	1.15
+++ usr.sbin/rpki-client/cert.c	23 Jul 2020 16:00:06 -0000
@@ -1128,7 +1128,7 @@ ta_parse(X509 **xp, const char *fn, cons
 		if ((opk = X509_get_pubkey(*xp)) == NULL)
 			cryptowarnx("%s: RFC 6487 (trust anchor): "
 			    "missing pubkey", fn);
-		else if (!EVP_PKEY_cmp(pk, opk))
+		else if (EVP_PKEY_cmp(pk, opk) != 1)
 			cryptowarnx("%s: RFC 6487 (trust anchor): "
 			    "pubkey does not match TAL pubkey", fn);
 		else
@@ -1136,8 +1136,7 @@ ta_parse(X509 **xp, const char *fn, cons
 
 		EVP_PKEY_free(pk);
 		EVP_PKEY_free(opk);
-	} else
-		rc = 1;
+	}
 
 	if (rc == 0) {
 		cert_free(p);
