untrusted comment: verify with openbsd-65-base.pub
RWSZaRmt1LEQT+90Dz+ZEHA8c0iNg4xSRXhfutGjVc6l/lwWkX3fHf/EW+Zvpve23IzkLsJU/vteZjYN0HD36tEkOw/h1wDIbA8=

OpenBSD 6.5 errata 030, January 30, 2020:

An incorrect check allows an attacker to trick mbox delivery into executing
arbitrary commands as root and lmtp delivery into executing arbitrary commands
as an unprivileged user.

Apply by doing:
    signify -Vep /etc/signify/openbsd-65-base.pub -x 030_smtpd_exec.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install smtpd:
    cd /usr/src/usr.sbin/smtpd
    make obj
    make
    make install

Index: usr.sbin/smtpd/smtp_session.c
===================================================================
RCS file: /cvs/src/usr.sbin/smtpd/smtp_session.c,v
retrieving revision 1.389.2.1
diff -u -p -r1.389.2.1 smtp_session.c
--- usr.sbin/smtpd/smtp_session.c	1 Aug 2019 23:09:35 -0000	1.389.2.1
+++ usr.sbin/smtpd/smtp_session.c	26 Jan 2020 05:54:47 -0000
@@ -2167,24 +2167,22 @@ smtp_mailaddr(struct mailaddr *maddr, ch
 		memmove(maddr->user, p, strlen(p) + 1);
 	}
 
-	if (!valid_localpart(maddr->user) ||
-	    !valid_domainpart(maddr->domain)) {
-		/* accept empty return-path in MAIL FROM, required for bounces */
-		if (mailfrom && maddr->user[0] == '\0' && maddr->domain[0] == '\0')
-			return (1);
+	/* accept empty return-path in MAIL FROM, required for bounces */
+	if (mailfrom && maddr->user[0] == '\0' && maddr->domain[0] == '\0')
+		return (1);
 
-		/* no user-part, reject */
-		if (maddr->user[0] == '\0')
-			return (0);
-
-		/* no domain, local user */
-		if (maddr->domain[0] == '\0') {
-			(void)strlcpy(maddr->domain, domain,
-			    sizeof(maddr->domain));
-			return (1);
-		}
+	/* no or invalid user-part, reject */
+	if (maddr->user[0] == '\0' || !valid_localpart(maddr->user))
 		return (0);
+
+	/* no domain part, local user */
+	if (maddr->domain[0] == '\0') {
+		(void)strlcpy(maddr->domain, domain,
+			sizeof(maddr->domain));
 	}
+
+	if (!valid_domainpart(maddr->domain))
+		return (0);
 
 	return (1);
 }
