untrusted comment: verify with openbsd-65-base.pub
RWSZaRmt1LEQT/tsbjX5TJIDFugPOl+kzRq7pQgHML/w3rC07jBEOzgvTDkuSv1202FaS0DGFnFZYg5SDdooHYo9nj4egl/gmgM=

OpenBSD 6.5 errata 029, January 30, 2020:

smtpd can crash on opportunistic TLS downgrade, causing a denial of service.

Apply by doing:
    signify -Vep /etc/signify/openbsd-65-base.pub -x 029_smtpd_tls.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install smtpd:
    cd /usr/src/usr.sbin/smtpd
    make obj
    make
    make install

Index: usr.sbin/smtpd/mta_session.c
===================================================================
RCS file: /cvs/src/usr.sbin/smtpd/mta_session.c,v
retrieving revision 1.115
diff -u -p -r1.115 mta_session.c
--- usr.sbin/smtpd/mta_session.c	23 Dec 2018 16:37:53 -0000	1.115
+++ usr.sbin/smtpd/mta_session.c	20 Jan 2020 10:36:58 -0000
@@ -1234,40 +1234,20 @@ mta_io(struct io *io, int evt, void *arg
 		break;
 
 	case IO_ERROR:
+	case IO_TLSERROR:
 		log_debug("debug: mta: %p: IO error: %s", s, io_error(io));
-		if (!s->ready) {
-			mta_error(s, "IO Error: %s", io_error(io));
-			mta_connect(s);
-			break;
-		}
-		else if (!(s->flags & (MTA_FORCE_TLS|MTA_FORCE_SMTPS|MTA_FORCE_ANYSSL))) {
-			/* error in non-strict SSL negotiation, downgrade to plain */
-			if (s->flags & MTA_TLS) {
-				log_info("smtp-out: Error on session %016"PRIx64
-				    ": opportunistic TLS failed, "
-				    "downgrading to plain", s->id);
-				s->flags &= ~MTA_TLS;
-				s->flags |= MTA_DOWNGRADE_PLAIN;
-				mta_connect(s);
-				break;
-			}
-		}
-		mta_error(s, "IO Error: %s", io_error(io));
-		mta_free(s);
-		break;
 
-	case IO_TLSERROR:
-		log_debug("debug: mta: %p: TLS IO error: %s", s, io_error(io));
-		if (!(s->flags & (MTA_FORCE_TLS|MTA_FORCE_SMTPS|MTA_FORCE_ANYSSL))) {
+		if (s->state == MTA_STARTTLS && s->use_smtp_tls) {
 			/* error in non-strict SSL negotiation, downgrade to plain */
-			log_info("smtp-out: TLS Error on session %016"PRIx64
-			    ": TLS failed, "
+			log_info("smtp-out: Error on session %016"PRIx64
+			    ": opportunistic TLS failed, "
 			    "downgrading to plain", s->id);
 			s->flags &= ~MTA_TLS;
 			s->flags |= MTA_DOWNGRADE_PLAIN;
 			mta_connect(s);
 			break;
 		}
+
 		mta_error(s, "IO Error: %s", io_error(io));
 		mta_free(s);
 		break;
