untrusted comment: verify with openbsd-63-base.pub
RWRxzbLwAd76ZTnWAl3VzGasJ5AyIeyyx/8vvHRtpkogn1k/XZrgXrghYd+l4pTDSYQxT2AMfUBzVQLBAQCxAeUQ5S9zqWHzmAU=

OpenBSD 6.3 errata 020, October 25, 2018

The Xorg X server incorrectly validates options, allowing anyone to
overwrite arbitrary files.

Apply by doing:
    signify -Vep /etc/signify/openbsd-63-base.pub -x 020_xserver.patch.sig \
        -m - | (cd /usr/xenocara && patch -p0)

And then compile and rebuild the X server
    cd /usr/xenocara/xserver
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper build

Index: xserver/hw/xfree86/common/xf86Init.c
===================================================================
RCS file: /cvs/xenocara/xserver/hw/xfree86/common/xf86Init.c,v
diff -u -p -u -r1.26 -r1.27
--- xserver/hw/xfree86/common/xf86Init.c	8 Dec 2017 15:02:00 -0000	1.26
+++ xserver/hw/xfree86/common/xf86Init.c	25 Oct 2018 15:44:27 -0000	1.27
@@ -1145,14 +1145,18 @@ ddxProcessArgument(int argc, char **argv
     /* First the options that are not allowed with elevated privileges */
     if (!strcmp(argv[i], "-modulepath")) {
         CHECK_FOR_REQUIRED_ARGUMENT();
-        xf86CheckPrivs(argv[i], argv[i + 1]);
+        if (xf86PrivsElevated())
+              FatalError("\nInvalid argument -modulepath "
+                "with elevated privileges\n");
         xf86ModulePath = argv[i + 1];
         xf86ModPathFrom = X_CMDLINE;
         return 2;
     }
     if (!strcmp(argv[i], "-logfile")) {
         CHECK_FOR_REQUIRED_ARGUMENT();
-        xf86CheckPrivs(argv[i], argv[i + 1]);
+        if (xf86PrivsElevated())
+              FatalError("\nInvalid argument -logfile "
+                "with elevated privileges\n");
         xf86LogFile = argv[i + 1];
         xf86LogFileFrom = X_CMDLINE;
         return 2;
