untrusted comment: signature from openbsd 6.1 base secret key
RWQEQa33SgQSEsuLnZRkxV2vUkKrE76TU/yLQuykO3ig/ROiF8TrxocfIU/J4UWaj/ozgvib35CqXZDabZAJggi/BsMxaYs+BQ8=

OpenBSD 6.1 errata 005, May 5, 2017:

Expired pf source tracking entries never got removed, leading to
memory exhaustion.

Apply by doing:
    signify -Vep /etc/signify/openbsd-61-base.pub -x 005_pf_src_tracking.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/net/pf.c
===================================================================
RCS file: /cvs/src/sys/net/pf.c,v
retrieving revision 1.1019
diff -u -p -r1.1019 pf.c
--- sys/net/pf.c	17 Mar 2017 17:19:16 -0000	1.1019
+++ sys/net/pf.c	5 May 2017 17:00:46 -0000
@@ -1256,6 +1256,7 @@ pf_purge_expired_src_nodes(int waslocked
 				    &tree_src_tracking, cur);
 				locked = 1;
 			}
+			pf_remove_src_node(cur);
 		}
 	}
 
