untrusted comment: signature from openbsd 5.9 base secret key
RWQJVNompF3pwVB0suVN7VQx9B/MfTsC82K7HXMe/Z9vpnLmIZSCVDBvFdRpQuYkZD0g18ZgD2z+fXA9TXQvpRY9FASbjmUadAA=

OpenBSD 5.9 errata 22, Aug 02, 2016:

A missing NULL check in sysctl code results in a crash.

Apply by doing:
    signify -Vep /etc/signify/openbsd-59-base.pub -x 022_sysctl.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/kern/vfs_subr.c
===================================================================
RCS file: /cvs/src/sys/kern/vfs_subr.c,v
retrieving revision 1.238
diff -u -p -r1.238 vfs_subr.c
--- sys/kern/vfs_subr.c	5 Dec 2015 10:11:53 -0000	1.238
+++ sys/kern/vfs_subr.c	29 Jul 2016 19:06:14 -0000
@@ -1277,7 +1277,7 @@ vfs_sysctl(int *name, u_int namelen, voi
 			if (vfsp->vfc_typenum == name[0])
 				break;
 
-		if (vfsp == NULL)
+		if (vfsp == NULL || vfsp->vfc_vfsops->vfs_sysctl == NULL)
 			return (EOPNOTSUPP);
 
 		return ((*vfsp->vfc_vfsops->vfs_sysctl)(&name[1], namelen - 1,
