untrusted comment: signature from openbsd 5.9 base secret key
RWQJVNompF3pwY3hTr/yToUM9uaGJZxlLDp7+CScxTruNSLryJtcJ2V4ZnpRBehtQfGQVskPYTLWG8gOfYhuSjbxjKBUuc12YwU=

OpenBSD 5.9 errata 18, Jul 14, 2016:

Tick counting overflows could cause a kernel crash.

Apply by doing:
    signify -Vep /etc/signify/openbsd-59-base.pub -x 018_timeout.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/kern/kern_sig.c
===================================================================
RCS file: /cvs/src/sys/kern/kern_sig.c,v
retrieving revision 1.192
diff -u -p -r1.192 kern_sig.c
--- sys/kern/kern_sig.c	9 Jan 2016 06:13:43 -0000	1.192
+++ sys/kern/kern_sig.c	14 Jul 2016 02:43:08 -0000
@@ -1716,7 +1716,7 @@ sys___thrsigdivert(struct proc *p, void 
 	sigset_t *m;
 	sigset_t mask = SCARG(uap, sigmask) &~ sigcantmask;
 	siginfo_t si;
-	long long to_ticks = 0;
+	uint64_t to_ticks = 0;
 	int timeinvalid = 0;
 	int error = 0;
 
@@ -1733,7 +1733,7 @@ sys___thrsigdivert(struct proc *p, void 
 		if (ts.tv_nsec < 0 || ts.tv_nsec >= 1000000000)
 			timeinvalid = 1;
 		else {
-			to_ticks = (long long)hz * ts.tv_sec +
+			to_ticks = (uint64_t)hz * ts.tv_sec +
 			    ts.tv_nsec / (tick * 1000);
 			if (to_ticks > INT_MAX)
 				to_ticks = INT_MAX;
Index: sys/kern/kern_synch.c
===================================================================
RCS file: /cvs/src/sys/kern/kern_synch.c,v
retrieving revision 1.128
diff -u -p -r1.128 kern_synch.c
--- sys/kern/kern_synch.c	1 Feb 2016 23:34:31 -0000	1.128
+++ sys/kern/kern_synch.c	14 Jul 2016 02:43:08 -0000
@@ -475,7 +475,7 @@ thrsleep(struct proc *p, struct sys___th
 	long ident = (long)SCARG(uap, ident);
 	struct timespec *tsp = (struct timespec *)SCARG(uap, tp);
 	void *lock = SCARG(uap, lock);
-	long long to_ticks = 0;
+	uint64_t to_ticks = 0;
 	int abort, error;
 	clockid_t clock_id = SCARG(uap, clock_id) & 0x7;
 	int lockflags = SCARG(uap, clock_id) & 0x8;
@@ -500,7 +500,7 @@ thrsleep(struct proc *p, struct sys___th
 		}
 
 		timespecsub(tsp, &now, tsp);
-		to_ticks = (long long)hz * tsp->tv_sec +
+		to_ticks = (uint64_t)hz * tsp->tv_sec +
 		    (tsp->tv_nsec + tick * 1000 - 1) / (tick * 1000) + 1;
 		if (to_ticks > INT_MAX)
 			to_ticks = INT_MAX;
Index: sys/kern/kern_tc.c
===================================================================
RCS file: /cvs/src/sys/kern/kern_tc.c,v
retrieving revision 1.28
diff -u -p -r1.28 kern_tc.c
--- sys/kern/kern_tc.c	10 Dec 2014 02:44:47 -0000	1.28
+++ sys/kern/kern_tc.c	14 Jul 2016 02:43:43 -0000
@@ -357,7 +357,7 @@ tc_setclock(struct timespec *ts)
 	/* convert the bintime to ticks */
 	bintime_sub(&bt, &bt2);
 	bintime_add(&naptime, &bt);
-	adj_ticks = (long long)hz * bt.sec +
+	adj_ticks = (uint64_t)hz * bt.sec +
 	    (((uint64_t)1000000 * (uint32_t)(bt.frac >> 32)) >> 32) / tick;
 	if (adj_ticks > 0) {
 		if (adj_ticks > INT_MAX)
Index: sys/kern/kern_timeout.c
===================================================================
RCS file: /cvs/src/sys/kern/kern_timeout.c,v
retrieving revision 1.43
diff -u -p -r1.43 kern_timeout.c
--- sys/kern/kern_timeout.c	20 Jul 2015 23:47:20 -0000	1.43
+++ sys/kern/kern_timeout.c	14 Jul 2016 02:43:43 -0000
@@ -202,9 +202,9 @@ timeout_add(struct timeout *new, int to_
 int
 timeout_add_tv(struct timeout *to, const struct timeval *tv)
 {
-	long long to_ticks;
+	uint64_t to_ticks;
 
-	to_ticks = (long long)hz * tv->tv_sec + tv->tv_usec / tick;
+	to_ticks = (uint64_t)hz * tv->tv_sec + tv->tv_usec / tick;
 	if (to_ticks > INT_MAX)
 		to_ticks = INT_MAX;
 
@@ -214,9 +214,9 @@ timeout_add_tv(struct timeout *to, const
 int
 timeout_add_ts(struct timeout *to, const struct timespec *ts)
 {
-	long long to_ticks;
+	uint64_t to_ticks;
 
-	to_ticks = (long long)hz * ts->tv_sec + ts->tv_nsec / (tick * 1000);
+	to_ticks = (uint64_t)hz * ts->tv_sec + ts->tv_nsec / (tick * 1000);
 	if (to_ticks > INT_MAX)
 		to_ticks = INT_MAX;
 
@@ -226,9 +226,9 @@ timeout_add_ts(struct timeout *to, const
 int
 timeout_add_bt(struct timeout *to, const struct bintime *bt)
 {
-	long long to_ticks;
+	uint64_t to_ticks;
 
-	to_ticks = (long long)hz * bt->sec + (long)(((uint64_t)1000000 *
+	to_ticks = (uint64_t)hz * bt->sec + (long)(((uint64_t)1000000 *
 	    (uint32_t)(bt->frac >> 32)) >> 32) / tick;
 	if (to_ticks > INT_MAX)
 		to_ticks = INT_MAX;
@@ -239,9 +239,9 @@ timeout_add_bt(struct timeout *to, const
 int
 timeout_add_sec(struct timeout *to, int secs)
 {
-	long long to_ticks;
+	uint64_t to_ticks;
 
-	to_ticks = (long long)hz * secs;
+	to_ticks = (uint64_t)hz * secs;
 	if (to_ticks > INT_MAX)
 		to_ticks = INT_MAX;
 
@@ -251,9 +251,9 @@ timeout_add_sec(struct timeout *to, int 
 int
 timeout_add_msec(struct timeout *to, int msecs)
 {
-	long long to_ticks;
+	uint64_t to_ticks;
 
-	to_ticks = (long long)msecs * 1000 / tick;
+	to_ticks = (uint64_t)msecs * 1000 / tick;
 	if (to_ticks > INT_MAX)
 		to_ticks = INT_MAX;
 
