untrusted comment: signature from openbsd 5.9 base secret key
RWQJVNompF3pwTe7dOmOWMBWXdhiISZOviqukj22AGzB2QbNtvWN6YisOdPi0bX5ouCzQh72fL8c/womXb1bQkhHV341qqZHyQE=

OpenBSD 5.9 errata 16, Jul 14, 2016:

The mmap extension __MAP_NOFAULT could overcommit resources and crash
the system.

Apply by doing:
    signify -Vep /etc/signify/openbsd-59-base.pub -x 016_mmap.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/uvm/uvm_mmap.c
===================================================================
RCS file: /cvs/src/sys/uvm/uvm_mmap.c,v
retrieving revision 1.122
diff -u -p -r1.122 uvm_mmap.c
--- sys/uvm/uvm_mmap.c	11 Nov 2015 15:59:33 -0000	1.122
+++ sys/uvm/uvm_mmap.c	14 Jul 2016 03:10:40 -0000
@@ -491,7 +491,7 @@ sys_mmap(struct proc *p, void *v, regist
 			/* MAP_PRIVATE mappings can always write to */
 			maxprot |= PROT_WRITE;
 		}
-		if ((flags & MAP_ANON) != 0 ||
+		if ((flags & MAP_ANON) != 0 || (flags & __MAP_NOFAULT) != 0 ||
 		    ((flags & MAP_PRIVATE) != 0 && (prot & PROT_WRITE) != 0)) {
 			if (size >
 			    (p->p_rlimit[RLIMIT_DATA].rlim_cur - ptoa(p->p_vmspace->vm_dused))) {
@@ -510,7 +510,7 @@ sys_mmap(struct proc *p, void *v, regist
 
 is_anon:	/* label for SunOS style /dev/zero */
 
-		if ((flags & MAP_ANON) != 0 ||
+		if ((flags & MAP_ANON) != 0 || (flags & __MAP_NOFAULT) != 0 ||
 		    ((flags & MAP_PRIVATE) != 0 && (prot & PROT_WRITE) != 0)) {
 			if (size >
 			    (p->p_rlimit[RLIMIT_DATA].rlim_cur - ptoa(p->p_vmspace->vm_dused))) {
