untrusted comment: signature from openbsd 5.9 base secret key
RWQJVNompF3pwfl++n2NqTtA4hiNktHhRnHDtPW+Wvw8xQ3PIIPS9+bsumuDVODww2WOruIyGNCX+0IJbt+CWpcpwjhOJN+kMwk=

OpenBSD 5.9 errata 15, Jul 14, 2016:

ufs_readdir failed to limit size of memory allocation, leading to panics.

Apply by doing:
    signify -Vep /etc/signify/openbsd-59-base.pub -x 015_dirent.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/ufs/ufs/ufs_vnops.c
===================================================================
RCS file: /cvs/src/sys/ufs/ufs/ufs_vnops.c,v
retrieving revision 1.125.2.1
diff -u -p -u -r1.125 -r1.125.2.1
--- sys/ufs/ufs/ufs_vnops.c	16 Feb 2016 17:56:12 -0000	1.125
+++ sys/ufs/ufs/ufs_vnops.c	14 Jul 2016 03:37:14 -0000	1.125.2.1
@@ -1441,7 +1441,7 @@ ufs_readdir(void *v)
 	 */
 
 	/* read from disk, stopping on a block boundary, max 64kB */
-	readcnt = max(count, 64*1024) - entries;
+	readcnt = min(count, 64*1024) - entries;
 
 	auio = *uio;
 	auio.uio_iov = &aiov;
