untrusted comment: signature from openbsd 5.9 base secret key
RWQJVNompF3pwQ//Vm0EYMEfVUHNvKbo0HiwHJ/LVrYIgJnh3NyYLICgdqvrfTWFxChOdwWe1hAOR+vTqmOJDbx+cUaCD99Q0gA=

OpenBSD 5.9 errata 6, May 16, 2016:

Fix reliability issue in smtpd:
    * file pointer leak in filter error code path can cause smtpd to crash. 
    * logic issue in smtp state machine can cause smtpd to crash if session
      hits a specific error code path and is recycled.

Apply by doing:
    signify -Vep /etc/signify/openbsd-59-base.pub -x 006_smtpd.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install smtpd:
    cd /usr/src/usr.sbin/smtpd
    make obj
    make depend
    make
    make install

Index: usr.sbin/smtpd/filter.c
===================================================================
RCS file: /cvs/src/usr.sbin/smtpd/filter.c,v
retrieving revision 1.17
diff -u -p -r1.17 filter.c
--- usr.sbin/smtpd/filter.c	25 Mar 2016 15:06:58 -0000	1.17
+++ usr.sbin/smtpd/filter.c	12 May 2016 16:22:44 -0000
@@ -297,6 +297,8 @@ filter_event(uint64_t id, int event)
 	if (event == EVENT_DISCONNECT) {
 		io_clear(&s->iev);
 		iobuf_clear(&s->ibuf);
+		if (s->ofile)
+			fclose(s->ofile);
 		free(s);
 	}
 }
Index: usr.sbin/smtpd/smtp_session.c
===================================================================
RCS file: /cvs/src/usr.sbin/smtpd/smtp_session.c,v
retrieving revision 1.270
diff -u -p -r1.270 smtp_session.c
--- usr.sbin/smtpd/smtp_session.c	8 May 2016 20:24:01 -0000	1.270
+++ usr.sbin/smtpd/smtp_session.c	12 May 2016 16:22:45 -0000
@@ -1144,6 +1144,7 @@ smtp_filter_response(uint64_t id, int qu
 
 	case QUERY_EOM:
 		if (status != FILTER_OK) {
+			tree_pop(&wait_filter_data, s->id);
 			smtp_filter_rollback(s);
 			code = code ? code : 530;
 			line = line ? line : "Message rejected";
@@ -1449,6 +1450,8 @@ smtp_data_io_done(struct smtp_session *s
 	iobuf_clear(&s->obuf);
 
 	if (s->msgflags & MF_ERROR) {
+
+		tree_pop(&wait_filter_data, s->id);
 
 		smtp_filter_rollback(s);
 		smtp_queue_rollback(s);

