untrusted comment: signature from openbsd 5.7 base secret key
RWSvUZXnw9gUb9QmNtbRWSkZday2HFut2V3vLYdrzdrPhP9+tjmNSCP80RznxEG5F8xBFCrQ5q72NXRApbEC78rss1OSsrU/igs=

OpenBSD 5.7 errata 13, Jul 30, 2015:

Substitution commands might contain a newline in the replacement pattern
(escaped with a backslash before it), causing patch's understanding of
the state the ed child process is in to diverge from reality. This can
lead to patch unwillingly feeding '!' (execute shell command) lines to
ed.

Apply by doing:
    signify -Vep /etc/signify/openbsd-57-base.pub -x 013_patch.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install the patch utility:
    cd /usr/src/usr.bin/patch
    make obj
    make
    make install

Index: usr.bin/patch/pch.c
===================================================================
RCS file: /cvs/src/usr.bin/patch/pch.c,v
retrieving revision 1.51.2.1
diff -u -p -u -p -r1.51.2.1 pch.c
--- usr.bin/patch/pch.c	27 Jul 2015 16:10:54 -0000	1.51.2.1
+++ usr.bin/patch/pch.c	30 Jul 2015 23:36:35 -0000
@@ -1402,7 +1402,19 @@ do_ed_script(void)
 		    *t != '\0' && strchr("acdis", *t) != NULL) {
 			if (pipefp != NULL)
 				fputs(buf, pipefp);
-			if (*t != 'd' && *t != 's') {
+			if (*t == 's') {
+				for (;;) {
+					bool continued = false;
+					t = buf + strlen(buf) - 1;
+					while (--t >= buf && *t == '\\')
+						continued = !continued;
+					if (!continued ||
+					    pgets(buf, sizeof buf, pfp) == NULL)
+						break;
+					if (pipefp != NULL)
+						fputs(buf, pipefp);
+				}
+			} else if (*t != 'd') {
 				while (pgets(buf, sizeof buf, pfp) != NULL) {
 					p_input_line++;
 					if (pipefp != NULL)
