untrusted comment: signature from openbsd 5.5 base secret key
RWRGy8gxk9N935WG0mYXd13AzGVWbOgbfdooC8/ob6jvlOGupaDbcpAju9giU57WKQ0m1rDCUt4jvBI5ZmbWOOVdSRjnpAa42AI=

OpenBSD 5.5 errata 15, Nov 17, 2014:  Querying an invalid hostname with
gethostbyname(3) could cause a NULL deref.

Apply patch using:

    signify -Vep /etc/signify/openbsd-55-base.pub -x 015_asr.patch.sig \
        -m - | (cd /usr/src && patch -p0)

Then build and install libc

    cd /usr/src/lib/libc
    make obj
    make depend
    make
    make install

Also recompile any statically-linked binaries:

    cd /usr/src/bin
    make obj
    make depend
    make
    make install

    cd /usr/src/sbin
    make obj
    make depend
    make
    make install

Index: lib/libc/asr/gethostnamadr_async.c
===================================================================
RCS file: /cvs/src/lib/libc/asr/gethostnamadr_async.c,v
retrieving revision 1.25
diff -u -p -u -r1.25 gethostnamadr_async.c
--- lib/libc/asr/gethostnamadr_async.c	26 Feb 2014 20:00:08 -0000	1.25
+++ lib/libc/asr/gethostnamadr_async.c	5 Nov 2014 19:46:07 -0000
@@ -349,13 +349,12 @@ gethostnamadr_async_run(struct async *as
 		}
 
 		/*
-		 * No address found in the dns packet. The blocking version
-		 * reports this as an error.
+		 * No valid hostname or address found in the dns packet.
+		 * Ignore it.
 		 */
 		if ((as->as_type == ASR_GETHOSTBYNAME &&
 		     h->h.h_addr_list[0] == NULL) ||
-		    (as->as_type == ASR_GETHOSTBYADDR &&
-		     h->h.h_name == NULL)) {
+		    h->h.h_name == NULL) {
 			free(h);
 			async_set_state(as, ASR_STATE_NEXT_DB);
 			break;
Index: lib/libc/asr/getnetnamadr_async.c
===================================================================
RCS file: /cvs/src/lib/libc/asr/getnetnamadr_async.c,v
retrieving revision 1.11
diff -u -p -u -r1.11 getnetnamadr_async.c
--- lib/libc/asr/getnetnamadr_async.c	26 Feb 2014 20:00:08 -0000	1.11
+++ lib/libc/asr/getnetnamadr_async.c	5 Nov 2014 19:46:07 -0000
@@ -231,11 +231,11 @@ getnetnamadr_async_run(struct async *as,
 			n->n.n_net = as->as.netnamadr.addr;
 
 		/*
-		 * No address found in the dns packet. The blocking version
-		 * reports this as an error.
+		 * No valid hostname or address found in the dns packet.
+		 * Ignore it.
 		 */
-		if (as->as_type == ASR_GETNETBYNAME && n->n.n_net == 0) {
-			 /* XXX wrong */
+		if ((as->as_type == ASR_GETNETBYNAME && n->n.n_net == 0) ||
+		    n->n.n_name == NULL) {
 			free(n);
 			async_set_state(as, ASR_STATE_NEXT_DB);
 			break;
